/*
 * Decompiled with CFR 0.152.
 */
package exploit.conversion;

import flash.objects.FFill;
import flash.objects.FLine;
import java.awt.geom.GeneralPath;

public abstract class RBase {
    private FFill myFill;
    private FLine myLine;
    private boolean flipped;
    private int myID;
    public static final int EDGE = 1;
    public static final int CURVE = 0;
    private int myType;
    private RBase mySecondEdge;

    public RBase(int n, FFill fFill, FLine fLine) {
        this.myType = n;
        this.myFill = fFill;
        this.myLine = fLine;
        this.flipped = false;
        this.mySecondEdge = null;
    }

    public void setID(int n) {
        this.myID = n;
    }

    public int getID() {
        return this.myID;
    }

    public RBase getSecondEdge() {
        return this.mySecondEdge;
    }

    public void setSecondEdge(RBase rBase) {
        this.mySecondEdge = rBase;
    }

    public boolean isSameStyle(RBase rBase) {
        return this.myFill == rBase.getColor() && this.myLine == rBase.getLine();
    }

    public boolean isFill() {
        return this.myFill != null;
    }

    public boolean touch(RBase rBase, boolean bl) {
        if (this.acceptable(this.getStartX(), rBase.getEndX(), bl) && this.acceptable(this.getStartY(), rBase.getEndY(), bl)) {
            return true;
        }
        return this.acceptable(this.getEndX(), rBase.getStartX(), bl) && this.acceptable(this.getEndY(), rBase.getStartY(), bl);
    }

    public boolean connect(RBase rBase, boolean bl) {
        return this.acceptable(this.getEndX(), rBase.getStartX(), bl) && this.acceptable(this.getEndY(), rBase.getStartY(), bl);
    }

    public boolean acceptable(long l, long l2, boolean bl) {
        return this.distance(l, l2) < (long)(bl ? 4 : 2);
    }

    public long distance(long l, long l2) {
        if (l > l2) {
            return l - l2;
        }
        return l2 - l;
    }

    public boolean cyclic(RBase rBase) {
        if (this.getEndX() == rBase.getEndX() && this.getEndY() == rBase.getEndY()) {
            return true;
        }
        return this.getStartX() == rBase.getStartX() && this.getStartY() == rBase.getStartY();
    }

    public int getType() {
        return this.myType;
    }

    public FFill getFill() {
        return this.myFill;
    }

    public FFill getColor() {
        return this.myFill;
    }

    public FLine getLine() {
        return this.myLine;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public abstract long getStartX();

    public abstract long getEndX();

    public abstract long getStartY();

    public abstract long getEndY();

    public long getWidth() {
        long l;
        long l2 = this.getStartX();
        if (l2 > (l = this.getEndX())) {
            return l2 - l;
        }
        return l - l2;
    }

    public long getHeight() {
        long l;
        long l2 = this.getStartY();
        if (l2 > (l = this.getEndY())) {
            return l2 - l;
        }
        return l - l2;
    }

    public long getMidpointX() {
        long l;
        long l2 = this.getWidth();
        long l3 = this.getStartX();
        if (l3 > (l = this.getEndX())) {
            return l + l2 / 2L;
        }
        return l3 + l2 / 2L;
    }

    public long getMidpointY() {
        long l;
        long l2 = this.getHeight();
        long l3 = this.getStartY();
        if (l3 > (l = this.getEndY())) {
            return l + l2 / 2L;
        }
        return l3 + l2 / 2L;
    }

    public long getWidthOffset() {
        long l = this.getStartX();
        long l2 = this.getMidpointX();
        return l2 - l;
    }

    public long getHeightOffset() {
        long l = this.getStartY();
        long l2 = this.getMidpointY();
        return l2 - l;
    }

    public void flip() {
        this.flipped = true;
    }

    public abstract GeneralPath getPath();
}

